<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
	
	class Work_model extends MY_Model
	{
	    var $table = 'works';
	    var $column_order = array(null,'w.cdate', 'w.id','c.name','w.description','w.person','w.contact_no','a.adate','w.wtime',null,null,null,null);
        var $order = array('w.id' => 'asc');
	    
	    public function insert($table,$data)
    	{
    		$result = $this->f_save($table,$data);
    		if($result)
    		{
    			return $result;
    		}
    		return false;
    	}
    	
	    public function get_all($args)
		{
			$this->db->select(array('w.*','c.name','c.mobile_no','c.email'));
			$this->db->from('works w');
			$this->db->where('w.status',1);
			$this->db->join('client_master c','c.id=w.client_id');
			
			if(isset($args['where']))
			{
			    $where = $args['where'];
			    $this->db->where("$where");
			}
			if(isset($args['between']))
			{
			    $this->db->where($args['between'],NULL,false);
    		}
			
			if(isset($args['conditions']))
			{
				$this->db->where($args['conditions']);
			}
            if(isset($args['like']))
		    {
		        $this->db->like($args['like'],true,'');
		    }
			if(isset($args['group_by']))
			{
				$this->db->group_by($args['group_by']);
			}
			if(isset($args['numrows']))
			{
				return $this->db->count_all_results();
			}
			if(isset($args['order-by']))
			{
				$this->db->order_by($args['order_by'],$args['order']);
			}
			if(isset($args['limit']))
			{
				$this->db->limit($args['limit'],$args['offset']);
			}
			return $this->db->get()->result_array();
		}
		
		public function get_all_work($args)
		{
		    $cond="";
		    if(isset($args['client']) && $args['client'] != '')
		    {
		        $client = $args['client'];
		        $cond .= " and w.client_id='$client'";
		    }
		    if(isset($args['fdate']) && $args['fdate'] != '' && $args['fdate'] != '0000-00-00' && $args['fdate'] != '1970-01-01')
		    {
		        $fdate = $args['fdate'];
		        $cond .= " and w.cdate >='$fdate'";
		    }
		    if(isset($args['tdate']) && $args['tdate'] != '' && $args['tdate'] != '0000-00-00' && $args['tdate'] != '1970-01-01')
		    {
		        $tdate = $args['tdate'];
		        $cond .= " and w.cdate <='$tdate'";
		    }
		    if(isset($args['wstatus']) && $args['wstatus'] != '')
		    {
		        $wstatus = $args['wstatus'];
		        $cond .= " and w.wstatus='$wstatus'";
		    }
		    if(isset($args['staff']) && $args['staff'] != '')
		    {
		        $staff = $args['staff'];
		        $cond .= " and a.staff_id='$staff' and a.status='1'";
		    }
		    if(isset($args['ptype']) && $args['ptype'] != '')
		    {
		        $ptype = $args['ptype'];
		        $cond .= " and w.ptype='$ptype'";
		    }
		    
		    $res = $this->db->query("SELECT w.*,c.name,c.mobile_no,c.email,a.staff_id,a.adate,count(*) as cnt,count(f.status) as fcnt,f.remarks FROM `works` as w join client_master as c on c.id=w.client_id left JOIN followup as f on w.id=f.work_id left join work_assign as a on w.id=a.work_id where w.status=1 $cond group by w.id order by wstatus asc,priority desc,fcnt desc,w.cdate asc,w.id asc")->result_array();
			
			return $res;
		}
		
		public function get_completed($args)
		{
		    $cond="";
		    if(isset($args['client']) && $args['client'] != '')
		    {
		        $client = $args['client'];
		        $cond .= " and w.client_id='$client'";
		    }
		    if(isset($args['fdate']) && $args['fdate'] != '' && $args['fdate'] != '0000-00-00' && $args['fdate'] != '1970-01-01')
		    {
		        $fdate = $args['fdate'];
		        $fdatetime = $fdate." 00:00:00";
		        $cond .= " and s.etime >='$fdatetime'";
		    }
		    if(isset($args['tdate']) && $args['tdate'] != '' && $args['tdate'] != '0000-00-00' && $args['tdate'] != '1970-01-01')
		    {
		        $tdate = $args['tdate'];
		        $tdatetime = $tdate." 23:59:59";
		        $cond .= " and s.etime <='$tdatetime'";
		    }
		    if(isset($args['wstatus']) && $args['wstatus'] != '')
		    {
		        $wstatus = $args['wstatus'];
		        $cond .= " and w.wstatus='$wstatus'";
		    }
		    if(isset($args['staff']) && $args['staff'] != '')
		    {
		        $staff = $args['staff'];
		        $cond .= " and a.staff_id='$staff' and a.status='1'";
		    }
		    if(isset($args['ptype']) && $args['ptype'] != '')
		    {
		        $ptype = $args['ptype'];
		        $cond .= " and w.ptype='$ptype'";
		    }
		    if(isset($args['informed_by']) && $args['informed_by'] != '')
		    {
		        $informed_by = $args['informed_by'];
		        $cond .= " and n.staff_id='$informed_by'";
		    }
		     $cond .= " and s.type='1'";
		    //$res = $this->db->query("SELECT w.*,c.name,c.mobile_no,c.email,a.staff_id,a.adate,count(*) as cnt,count(f.status) as fcnt,f.remarks,s.etime FROM `works` as w join client_master as c on c.id=w.client_id left JOIN followup as f on w.id=f.work_id left join work_assign as a on w.id=a.work_id left join work_status as s on w.id=s.work_id and s.estatus=5 and s.type=1 where w.status=1 and w.wstatus=2 $cond group by w.id order by wstatus asc,priority desc,fcnt desc,w.cdate asc,w.id asc")->result_array();
			$res = $this->db->query("SELECT w.*,c.name,c.mobile_no,c.email,a.staff_id,a.adate,count(*) as cnt,count(f.status) as fcnt,f.remarks,s.etime FROM `works` as w join client_master as c on c.id=w.client_id left JOIN followup as f on w.id=f.work_id left join work_assign as a on w.id=a.work_id left join work_status as s on w.id=s.work_id left join work_inform as n on w.id=n.work_id and s.estatus=5 and s.type=1 where w.status=1 and w.wstatus=2 $cond group by w.id order by wstatus asc,priority desc,fcnt desc,w.cdate asc,w.id asc")->result_array();
	
			return $res;
		}
		
		public function get_terminated($args)
		{
		    $cond="";
		    if(isset($args['client']) && $args['client'] != '')
		    {
		        $client = $args['client'];
		        $cond .= " and w.client_id='$client'";
		    }
		    if(isset($args['fdate']) && $args['fdate'] != '' && $args['fdate'] != '0000-00-00' && $args['fdate'] != '1970-01-01')
		    {
		        $fdate = $args['fdate'];
		        $fdatetime = $fdate." 00:00:00";
		        $cond .= " and s.etime >='$fdatetime'";
		    }
		    if(isset($args['tdate']) && $args['tdate'] != '' && $args['tdate'] != '0000-00-00' && $args['tdate'] != '1970-01-01')
		    {
		        $tdate = $args['tdate'];
		        $tdatetime = $tdate." 23:59:59";
		        $cond .= " and s.etime <='$tdatetime'";
		    }
		    if(isset($args['wstatus']) && $args['wstatus'] != '')
		    {
		        $wstatus = $args['wstatus'];
		        $cond .= " and w.wstatus='$wstatus'";
		    }
		    if(isset($args['staff']) && $args['staff'] != '')
		    {
		        $staff = $args['staff'];
		        $cond .= " and a.staff_id='$staff' and a.status='1'";
		    }
		    if(isset($args['ptype']) && $args['ptype'] != '')
		    {
		        $ptype = $args['ptype'];
		        $cond .= " and w.ptype='$ptype'";
		    }
		    
		    $res = $this->db->query("SELECT w.*,c.name,c.mobile_no,c.email,a.staff_id,a.adate,count(*) as cnt,count(f.status) as fcnt,f.remarks,s.etime FROM `works` as w join client_master as c on c.id=w.client_id left JOIN followup as f on w.id=f.work_id left join work_assign as a on w.id=a.work_id left join work_status as s on w.id=s.work_id and s.estatus=5 and s.type=1 where w.status=1 and w.wstatus=3 $cond group by w.id order by wstatus asc,priority desc,fcnt desc,w.cdate asc,w.id asc")->result_array();
			
			return $res;
		}
		
		public function get_pending_work($args)
		{
		    $cond="";
		    if(isset($args['client']) && $args['client'] != '')
		    {
		        $client = $args['client'];
		        $cond .= " and w.client_id='$client'";
		    }
		    if(isset($args['fdate']) && $args['fdate'] != '' && $args['fdate'] != '0000-00-00' && $args['fdate'] != '1970-01-01')
		    {
		        $fdate = $args['fdate'];
		        $cond .= " and w.cdate >='$fdate'";
		    }
		    if(isset($args['tdate']) && $args['tdate'] != '' && $args['tdate'] != '0000-00-00' && $args['tdate'] != '1970-01-01') {
		        $tdate = $args['tdate'];
		        $cond .= " and w.cdate <='$tdate'";
		    }
		    if(isset($args['wstatus']) && $args['wstatus'] != '') {
		        $wstatus = $args['wstatus'];
		        if($wstatus == '10') {
		            $cond .= " and w.wstatus='0'";
		        } else {
		            $cond .= " and w.wstatus='$wstatus'";
		        }
		    }
		    if(isset($args['staff']) && $args['staff'] != '') {
		        $staff = $args['staff'];
		        $cond .= " and a.staff_id='$staff' and a.status='1'";
		    }
		    if(isset($args['ptype']) && $args['ptype'] != '') {
		        $ptype = $args['ptype'];
		        $cond .= " and w.ptype='$ptype'";
		    }
		    if(isset($args['added_by']) && $args['added_by'] != '') {
		        $added_by = $args['added_by'];
		        $cond .= " and w.added_by='$added_by'";
		    }
		    
            $utype = $args['utype'];
            if($utype !=7) {
                $staff_id=$args['staff_id'];
                $cond.=" and w.created_by!=17";
            }
            
            $res = $this->db->query("SELECT w.*,c.name,c.mobile_no,c.email,a.staff_id,a.adate,count(*) as cnt,count(f.status) as fcnt,f.remarks FROM `works` as w join client_master as c on c.id=w.client_id left JOIN followup as f on w.id=f.work_id left join work_assign as a on w.id=a.work_id where w.status=1 and w.wstatus not in (2,3) $cond group by w.id order by wstatus asc,priority desc,fcnt desc,w.cdate asc,w.id asc")->result_array();
            
			return $res;
		}
		
		public function get_all_my_works($args)
		{
		    $cond="";
		    $uid = $this->session->userdata('uid');
		    
		    $res = $this->db->query("SELECT w.*,c.name,c.mobile_no,c.email,a.staff_id,a.adate,count(*) as cnt FROM `works` as w join client_master as c on c.id=w.client_id left JOIN followup as f on w.id=f.work_id join work_assign as a on w.id=a.work_id where w.status=1 and a.staff_id='$uid' $cond group by w.id order by wstatus asc,priority desc,cnt desc,w.cdate asc,w.id asc")->result_array();
			
			return $res;
		}
		
		public function get_all_my_pending_works($args)
		{
		    $cond="";
		    $uid = $this->session->userdata('uid');
		    
		    $res = $this->db->query("SELECT w.*,c.name,c.mobile_no,c.email,a.staff_id,a.adate,count(*) as cnt FROM `works` as w join client_master as c on c.id=w.client_id left JOIN followup as f on w.id=f.work_id join work_assign as a on w.id=a.work_id where w.status=1 and w.wstatus<'2' and a.staff_id='$uid' $cond group by w.id order by wstatus asc,priority desc,cnt desc,w.cdate asc,w.id asc")->result_array();
			
			return $res;
		}
		
		public function get_all_my_pending_works_ch($staff_id)
		{
		    $cond="";
		    
		    
		    $res = $this->db->query("SELECT w.*,c.name,c.mobile_no,c.email,a.staff_id,a.adate,count(*) as cnt FROM `works` as w join client_master as c on c.id=w.client_id left JOIN followup as f on w.id=f.work_id join work_assign as a on w.id=a.work_id where w.status=1 and w.wstatus<'2' and a.staff_id='$staff_id' $cond group by w.id order by wstatus asc,priority desc,cnt desc,w.cdate asc,w.id asc")->result_array();
			
			return $res;
		}
		
		public function get_my_works()
		{
		    $this->get_my_works_query();
            if($this->input->post('length') != -1)
            $this->db->limit($this->input->post('length'), $this->input->post('start'));
            $query = $this->db->get();
            return $query->result();
		}
		
		public function count_all()
        {
            $this->db->from($this->table);
            return $this->db->count_all_results();
        }
        
        public function count_my_works_filtered()
        {
            $this->get_my_works_query();
            $query = $this->db->get();
            return $query->num_rows();
        }
		
		private function get_my_works_query()
        {
            $uid = $this->session->userdata('uid');
            
            $this->db->select(array('w.*','c.name','c.mobile_no','c.email','a.staff_id','a.adate','count(*) as cnt'));
            $this->db->from('works as w');
            $this->db->join('client_master as c','c.id=w.client_id');
            $this->db->join('followup as f','w.id=f.work_id','left');
            $this->db->join('work_assign as a','w.id=a.work_id');
            $this->db->where(array('w.status'=>1,'w.wstatus <'=>2,'a.staff_id'=>$uid));
            $this->db->group_by('w.id');
            $this->db->order_by('wstatus asc,priority desc,cnt desc,w.cdate asc,w.id asc');
            
            $i = 0;
            
            if($_POST['search']['value']) // if datatable send POST for search
            {
                $skey = $_POST['search']['value'];
                $this->db->where("(w.id like '%$skey%' or c.name like '%$skey%' or w.description like '%$skey%')");
                
                /*$this->db->group_start();
                $this->db->like('w.id', $_POST['search']['value']);
                $this->db->or_like('w.cdate', $_POST['search']['value']);
                $this->db->or_like('c.name', $_POST['search']['value']);
                $this->db->or_like('w.description', $_POST['search']['value']);
                $this->db->group_end();*/
            }
         
            if(isset($_POST['order'])) // here order processing
            {
                $this->db->order_by($this->column_order[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
            } 
            else if(isset($this->order))
            {
                $order = $this->order;
                $this->db->order_by(key($order), $order[key($order)]);
            }
        }
		
	public function count_my_completed_works_filtered()
        {
            $this->get_my_completed_works_query();
            $query = $this->db->get();
            return $query->num_rows();
        }	
		public function get_my_completed_works()
		{
		    $this->get_my_completed_works_query();
            if($this->input->post('length') != -1)
            $this->db->limit($this->input->post('length'), $this->input->post('start'));
            $query = $this->db->get();
            return $query->result();
		}
		
		private function get_my_completed_works_query()
        {
            $uid = $this->session->userdata('uid');
            
            $this->db->select(array('w.*','c.name','c.mobile_no','c.email','a.staff_id','a.adate','count(*) as cnt'));
            $this->db->from('works as w');
            $this->db->join('client_master as c','c.id=w.client_id');
            $this->db->join('followup as f','w.id=f.work_id','left');
            $this->db->join('work_assign as a','w.id=a.work_id');
            $this->db->where(array('w.status >='=>2,'a.staff_id'=>$uid));
            $this->db->group_by('w.id');
            $this->db->order_by('wstatus asc,priority desc,cnt desc,w.cdate asc,w.id asc');
            
            $i = 0;
            
            if($_POST['search']['value']) // if datatable send POST for search
            {
                $skey = $_POST['search']['value'];
                $this->db->where("(w.id like '%$skey%' or c.name like '%$skey%' or w.description like '%$skey%')");
                
              
            }
         
            if(isset($_POST['order'])) // here order processing
            {
                $this->db->order_by($this->column_order[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
            } 
            else if(isset($this->order))
            {
                $order = $this->order;
                $this->db->order_by(key($order), $order[key($order)]);
            }
        }
		
		public function get_all_my_completed_works($args)
		{
		    $cond="";
		    $uid = $this->session->userdata('uid');
		    
		    $res = $this->db->query("SELECT w.*,c.name,c.mobile_no,c.email,a.staff_id,a.adate,count(*) as cnt FROM `works` as w join client_master as c on c.id=w.client_id left JOIN followup as f on w.id=f.work_id join work_assign as a on w.id=a.work_id where w.status=1 and w.wstatus>='2' and a.staff_id='$uid' $cond group by w.id order by wstatus asc,priority desc,cnt desc,w.cdate asc,w.id asc")->result_array();
			
			return $res;
		}
		
		public function get_all_my_completed_works_ch($staff_id)
		{
		    $cond="";
		   
		    
		    $res = $this->db->query("SELECT w.*,c.name,c.mobile_no,c.email,a.staff_id,a.adate,count(*) as cnt FROM `works` as w join client_master as c on c.id=w.client_id left JOIN followup as f on w.id=f.work_id join work_assign as a on w.id=a.work_id where w.status=1 and w.wstatus>='2' and a.staff_id='$staff_id' $cond group by w.id order by wstatus asc,priority desc,cnt desc,w.cdate asc,w.id asc")->result_array();
			
			return $res;
		}
		
		public function get_all_my_ongoing_works($args)
		{
		    $cond="";
		    $uid = $this->session->userdata('uid');
		    
		    $res = $this->db->query("SELECT w.*,c.name,c.mobile_no,c.email,a.staff_id,a.adate,count(*) as cnt FROM `works` as w join client_master as c on c.id=w.client_id left JOIN followup as f on w.id=f.work_id join work_assign as a on w.id=a.work_id where w.status=1 and w.wstatus=0 and a.staff_id='$uid' $cond group by w.id order by wstatus asc,priority desc,cnt desc,w.cdate asc,w.id asc")->result_array();
			
			return $res;
		}
		
		public function get_work_report($args)
		{
		    $cond="";
		    if(isset($args['staff']) && $args['staff'] != '')
		    {
		        $staff = $args['staff'];
		        $cond .= " and s.staff_id='$staff'";
		    }
		    if(isset($args['fdate']) && $args['fdate'] != '' && $args['fdate'] != '0000-00-00' && $args['fdate'] != '1970-01-01')
		    {
		        $fdate = $args['fdate'];
		        $cond .= " and s.udate >='$fdate'";
		    }
		    if(isset($args['tdate']) && $args['tdate'] != '' && $args['tdate'] != '0000-00-00' && $args['tdate'] != '1970-01-01')
		    {
		        $tdate = $args['tdate'];
		        $cond .= " and s.udate <='$tdate'";
		    }
		    
		    $res = $this->db->query("SELECT s.*,w.cdate,w.category,w.description,w.wtime,w.wstatus,w.wcount,w.wtaken,c.name FROM `work_status` as s join works as w on w.id=s.work_id JOIN client_master as c on c.id=w.client_id where s.status=1 and s.type='1' $cond order by s.id asc")->result_array();
			
			return $res;
		}
		
		public function get_works($args)
		{
		    $cond="";
		    if(isset($args['staff']) && $args['staff'] != '')
		    {
		        $staff = $args['staff'];
		        $cond .= " and s.staff_id='$staff'";
		    }
		    if(isset($args['fdate']) && $args['fdate'] != '' && $args['fdate'] != '0000-00-00' && $args['fdate'] != '1970-01-01')
		    {
		        $fdate = $args['fdate'];
		        $cond .= " and s.udate >='$fdate'";
		    }
		    if(isset($args['tdate']) && $args['tdate'] != '' && $args['tdate'] != '0000-00-00' && $args['tdate'] != '1970-01-01')
		    {
		        $tdate = $args['tdate'];
		        $cond .= " and s.udate <='$tdate'";
		    }
		    
		    $res = $this->db->query("SELECT s.*,t.wtype,t.wstatus FROM work_status as s inner join work_types as t on s.type=t.id where s.status=1 $cond order by s.stime asc,s.etime asc")->result_array();
			
			return $res;
		}
		
		public function get_works_det($type,$id)
		{
		    $work_det=array();
		    if($type!='' && $type>0 && $id!='' && $id>0)
		    {
    		    if($type=='1')
    		    {
    		        $row = $this->db->query("SELECT * FROM works as w inner join client_master as c on w.client_id=c.id where w.id='$id' and w.status=1")->row_array();
    		        if(!empty($row))
    		        {
    		        $work_det = array('work'=>$row['description'],'client'=>$row['name'],'category'=>$row['category'],'wcount'=>$row['wcount'],'nattend'=>$row['nattend'],'wtaken'=>$row['wtaken']);
    		        }
    		    }
    		    else if($type=='2')
    		    {
    		        $row = $this->db->query("SELECT * FROM call_details as w left join client_master as c on w.client=c.id where w.id='$id'")->row_array();
    		        $call="";
    		        if($row['ctype']=='0'){ $call="Incoming Call"; }elseif($row['ctype']=='1'){ $call="Outgoing Call"; }
    		        
    		        $work_det = array('work'=>$call,'client'=>$row['name']." ".$row['person']);
    		    }
    		    else if($type=='3')
    		    {
    		        $row = $this->db->query("SELECT * FROM discussion_details as d left join users as u on d.staff_to=u.id where d.id='$id'")->row_array();
    		        
    		        $work_det = array('work'=>'Discussion','client'=>$row['fname']);
    		    }
    		    else
    		    {
    		        $row = $this->db->query("SELECT t.wtype FROM other_details as d left join work_types as t on d.wtype=t.id where d.id='$id'")->row_array();
    		        
    		        $work_det = array('work'=>$row['wtype'],'client'=>'');
    		    }
		    }
		    
		    return $work_det;
		}
		
		
		
	public function get_works_det_disc($type,$id,$clint)
		{
		    $work_det=array();
		    if($type!='' && $type>0 && $id!='' && $id>0 && $clint!='' && $clint>0)
		    {
    		    if($type=='1')
    		    {
    		        $row = $this->db->query("SELECT * FROM works as w inner join client_master as c on w.client_id=c.id where w.id='$id' and w.status=1")->row_array();
    		        $work_det = array('work'=>$row['description'],'client'=>$row['name'],'category'=>$row['category'],'wcount'=>$row['wcount'],'nattend'=>$row['nattend'],'wtaken'=>$row['wtaken']);
    		    }
    		    else if($type=='2')
    		    {
    		        $row = $this->db->query("SELECT * FROM call_details as w left join client_master as c on w.client=c.id where w.id='$id'")->row_array();
    		        $call="";
    		        if($row['ctype']=='0'){ $call="Incoming Call"; }elseif($row['ctype']=='1'){ $call="Outgoing Call"; }
    		        
    		        $work_det = array('work'=>$call,'client'=>$row['name']." ".$row['person']);
    		    }
    		    else if($type=='3')
    		    {
    		        $row = $this->db->query("SELECT * FROM discussion_details as d left join users as u on d.staff_to=u.id where d.id='$id' and d.staff_to='$clint'")->row_array();
    		        
    		        $work_det = array('work'=>'Discussion','client'=>$row['fname']);
    		    }
    		    else
    		    {
    		        $row = $this->db->query("SELECT t.wtype FROM other_details as d left join work_types as t on d.wtype=t.id where d.id='$id'")->row_array();
    		        
    		        $work_det = array('work'=>$row['wtype'],'client'=>'');
    		    }
		    }
		    
		    return $work_det;
		}	
		
		
		
	#-----------------------------------------------------------------daily work report--------------------------------------------------------------------------------
	
	
		public function get_daily_works($args)
		{
		    $cond="";
		    if(isset($args['staff']) && $args['staff'] != '')
		    {
		        $staff = $args['staff'];
		        $cond .= " and s.staff_id='$staff'";
		    }
		    if(isset($args['fdate']) && $args['fdate'] != '' && $args['fdate'] != '0000-00-00' && $args['fdate'] != '1970-01-01')
		    {
		        $fdate = $args['fdate'];
		        $cond .= " and s.udate >='$fdate'";
		    }
		    if(isset($args['tdate']) && $args['tdate'] != '' && $args['tdate'] != '0000-00-00' && $args['tdate'] != '1970-01-01')
		    {
		        $tdate = $args['tdate'];
		        $cond .= " and s.udate <='$tdate'";
		    }
		    
		    $res = $this->db->query("SELECT distinct s.work_id,s.type,s.udate FROM work_status as s inner join work_types as t on s.type=t.id where s.status=1 $cond order by s.stime asc")->result_array();
			
			return $res;
		}
		
	
	public function get_daily_staff_works($args)
		{
		    $cond="";
		    if(isset($args['staff']) && $args['staff'] != '')
		    {
		        $staff = $args['staff'];
		        $cond .= " and s.staff_id='$staff'";
		    }
		    if(isset($args['work_id']) && $args['work_id'] != '')
		    {
		        $work_id = $args['work_id'];
		        $cond .= " and s.work_id='$work_id'";
		    }
		    if(isset($args['type']) && $args['type'] != '')
		    {
		        $type = $args['type'];
		        $cond .= " and s.type='$type'";
		    }
		    if(isset($args['fdate']) && $args['fdate'] != '' && $args['fdate'] != '0000-00-00' && $args['fdate'] != '1970-01-01')
		    {
		        $fdate = $args['fdate'];
		        $cond .= " and s.udate >='$fdate'";
		    }
		    if(isset($args['tdate']) && $args['tdate'] != '' && $args['tdate'] != '0000-00-00' && $args['tdate'] != '1970-01-01')
		    {
		        $tdate = $args['tdate'];
		        $cond .= " and s.udate <='$tdate'";
		    }
		    
		    $res = $this->db->query("SELECT * FROM work_status as s inner join work_types as t on s.type=t.id where s.status=1 $cond order by s.stime asc")->result_array();
			
			return $res;
		}
	
	
	/*public function get_start_time_works($args)
		{
		    $cond="";
		    if(isset($args['work_id']) && $args['work_id'] != '')
		   {
		     $wk_id = $args['work_id'];
		     $cond .= " and s.work_id='$wk_id'";  
		   }
		     if(isset($args['type']) && $args['type'] != '')
		   {
		     $type = $args['type'];
		     $cond .= " and s.type='$type'";  
		   }
		    $res = $this->db->query("SELECT s.time FROM work_status as s inner join work_types as t on s.type=t.id where s.status=1 $cond order by s.stime asc")->result_array();
			
			return $res;
		}*/
	
	#---------------------------------------------------------------------------------------------------------------------------------------------------
	    public function get_work_report_new($args)
		{
		    $cond="";
		    if(isset($args['staff']) && $args['staff'] != '')
		    {
		        $staff = $args['staff'];
		        $cond .= " and s.staff_id='$staff'";
		    }
		   if(isset($args['work_id']) && $args['work_id'] != '')
		   {
		     $wk_id = $args['work_id'];
		     $cond .= " and s.work_id='$wk_id'";  
		   }
		    $cond .= " and s.type='1'";
		    $res = $this->db->query("SELECT s.*,w.cdate,w.description,w.wtime,w.wstatus,c.name FROM `work_status` as s join works as w on w.id=s.work_id JOIN client_master as c on c.id=w.client_id where s.status=1 $cond order by s.id asc")->result_array();
			
			return $res;
		}
		
		public function get_call_work_report_new($args)
		{
		    $cond="";
		    if(isset($args['staff']) && $args['staff'] != '')
		    {
		        $staff = $args['staff'];
		        $cond .= " and s.staff_id='$staff'";
		    }
		   if(isset($args['work_id']) && $args['work_id'] != '')
		   {
		     $wk_id = $args['work_id'];
		     $cond .= " and s.work_id='$wk_id'";  
		   }
		   $cond .= " and s.type !='1'";
		    $res = $this->db->query("SELECT s.*,w.cdate,c.name FROM `work_status` as s join call_details as w on w.id=s.work_id JOIN client_master as c on c.id=w.client where s.status=1 $cond order by s.id asc")->result_array();
			
			return $res;
		}
		
		public function listing($args=array())
		{
			$clients = array();
			$clients[''] = 'Select';
			$this->db->select(array('id','wtype','wstatus','del_status'));
			$this->db->from('work_types');
			$this->db->where('wtype !=','work');
			if(isset($args['conditions']))
			{
				$this->db->where($args['conditions']);
			}
			
			$rows = $this->db->get()->result_array();
			if(!empty($rows))
			{
				foreach($rows as $key=>$row)
				{
					$clients[$row['id']] = $row['wtype'];
				}
			}
			return $clients;
		}
		
			public function listing_others($args=array())
		{
			$clients = array();
			$clients[''] = 'Select';
			$this->db->select(array('id','wtype','wstatus','del_status'));
			$this->db->from('work_types');
			
			if(isset($args['conditions']))
			{
				$this->db->where($args['conditions']);
			}
			
			$rows = $this->db->get()->result_array();
			if(!empty($rows))
			{
				foreach($rows as $key=>$row)
				{
					$clients[$row['id']] = $row['wtype'];
				}
			}
			return $clients;
		}
		
		public function get_call_details($args)
		{
		    $cond = "id > 0";
		    if(isset($args['client']) && $args['client'] != '')
		    {
		        $client = $args['client'];
		        $cond .= " and client='$client'";
		    }
		    if(isset($args['fdate']) && $args['fdate'] != '' && $args['fdate'] != '0000-00-00' && $args['fdate'] != '1970-01-01')
		    {
		        $fdate = $args['fdate'];
		        $cond .= " and cdate >='$fdate'";
		    }
		    if(isset($args['tdate']) && $args['tdate'] != '' && $args['tdate'] != '0000-00-00' && $args['tdate'] != '1970-01-01')
		    {
		        $tdate = $args['tdate'];
		        $cond .= " and cdate <='$tdate'";
		    }
		   
		    if(isset($args['staff']) && $args['staff'] != '')
		    {
		        $staff = $args['staff'];
		        $cond .= " and staff='$staff'";
		    }
		    
		    $res = $this->db->query("SELECT * FROM `call_details` where $cond")->result_array();
			
			return $res;
		}
		
		public function get_discuss_details($args)
		{
		    $cond = "id > 0";
		    if(isset($args['fdate']) && $args['fdate'] != '' && $args['fdate'] != '0000-00-00' && $args['fdate'] != '1970-01-01')
		    {
		        $fdate = $args['fdate'];
		        $cond .= " and cdate >='$fdate'";
		    }
		    if(isset($args['tdate']) && $args['tdate'] != '' && $args['tdate'] != '0000-00-00' && $args['tdate'] != '1970-01-01')
		    {
		        $tdate = $args['tdate'];
		        $cond .= " and cdate <='$tdate'";
		    }
		   
		    if(isset($args['staff']) && $args['staff'] != '')
		    {
		        $staff = $args['staff'];
		        $cond .= " and staff='$staff'";
		    }
		    
		    $res = $this->db->query("SELECT * FROM `discussion_details` where $cond")->result_array();
			
			return $res;
		}
		
		public function work_cats()
		{
			$wcats = array();
			$this->db->select('*');
			$this->db->from('work_category');
			$rows = $this->db->get()->result_array();
			if(!empty($rows))
			{
				foreach($rows as $key=>$row)
				{
					$wcats[$row['id']] = $row['category'];
				}
			}
			return $wcats;
		}
		
		public function get_informed_person($work_id){

    		$row = $this->db->select('staff_id')->from('work_inform')->where(array('work_id' => $work_id))->get()->row_array();
    		if(!empty($row)){
    			return $row['staff_id'];
    		}
    		return false;
		}
		
		public function get_other_details($args)
		{
		    $cond = "id > 0";
		    if(isset($args['fdate']) && $args['fdate'] != '' && $args['fdate'] != '0000-00-00' && $args['fdate'] != '1970-01-01')
		    {
		        $fdate = $args['fdate'];
		        $cond .= " and cdate >='$fdate'";
		    }
		    if(isset($args['tdate']) && $args['tdate'] != '' && $args['tdate'] != '0000-00-00' && $args['tdate'] != '1970-01-01')
		    {
		        $tdate = $args['tdate'];
		        $cond .= " and cdate <='$tdate'";
		    }
		   
		    if(isset($args['staff']) && $args['staff'] != '')
		    {
		        $staff = $args['staff'];
		        $cond .= " and staff='$staff'";
		    }
		    
		    $res = $this->db->query("SELECT * FROM `other_details` where $cond")->result_array();
			
			return $res;
		}
		
		public function get_paid_pending($client)
		{
            $res = $this->db->query("SELECT * FROM `works` where status=1 and client_id='$client' and ptype='1' and id not in(select work_id from work_estimate_items where status='1')")->result_array();
			return $res;
		}
		
		public function get_estimate_report($args){
			$this->db->select('*');
			$this->db->from('work_estimate');
			$this->db->where('status',1);
			
			if(isset($args['conditions'])){
				$this->db->where($args['conditions']);
			}
            if(isset($args['like'])){
                $this->db->like($args['like'],true,'');
            }
			if(isset($args['group_by'])){
				$this->db->group_by($args['group_by']);
			}
			if(isset($args['numrows'])){
				return $this->db->count_all_results();
			}
			if(isset($args['order-by'])){
				$this->db->order_by($args['order_by'],$args['order']);
			}
			if(isset($args['limit'])){
				$this->db->limit($args['limit'],$args['offset']);
			}
			return $this->db->get()->result_array();
		}
		
		public function get_estimate_det($args){
			$this->db->select(array('e.id as eid','e.client_id','e.edate','e.estatus','ei.*'));
			$this->db->from('work_estimate as e');
			$this->db->join('work_estimate_items as ei','e.id=ei.eid');
			$this->db->where(array('e.status'=>1,'ei.status'=>1));
			
			if(isset($args['conditions'])){
				$this->db->where($args['conditions']);
			}
            if(isset($args['like'])){
		        $this->db->like($args['like'],true,'');
		    }
			if(isset($args['group_by'])){
				$this->db->group_by($args['group_by']);
			}
			if(isset($args['numrows'])){
				return $this->db->count_all_results();
			}
			if(isset($args['order-by'])){
				$this->db->order_by($args['order_by'],$args['order']);
			}
			if(isset($args['limit'])){
				$this->db->limit($args['limit'],$args['offset']);
			}
			return $this->db->get()->result_array();
		}
		
		public function get_estimate_amount($eid){
		    $total=0;
			$this->db->select_sum('amount');
			$this->db->from('work_estimate_items');
			$this->db->where('eid',$eid);
			$row = $this->db->get()->row_array();
			
			if(!empty($row)){ $total = $row['amount']; }
			return $total;
		}
		
		public function get_invoice_report($args)
		{
			$this->db->select('*');
			$this->db->from('work_invoice');
			$this->db->where('status',1);
			
			if(isset($args['conditions']))
			{
				$this->db->where($args['conditions']);
			}
            if(isset($args['like']))
		    {
		        $this->db->like($args['like'],true,'');
		    }
			if(isset($args['group_by']))
			{
				$this->db->group_by($args['group_by']);
			}
			if(isset($args['numrows']))
			{
				return $this->db->count_all_results();
			}
			if(isset($args['order-by']))
			{
				$this->db->order_by($args['order_by'],$args['order']);
			}
			if(isset($args['limit']))
			{
				$this->db->limit($args['limit'],$args['offset']);
			}
			return $this->db->get()->result_array();
		}
		
		public function get_invoice_amount($eid)
		{
		    $total=0;
			$this->db->select_sum('amount');
			$this->db->from('work_invoice_items');
			$this->db->where('inv_id',$eid);
			$row = $this->db->get()->row_array();
			
			if(!empty($row)){ $total = $row['amount']; }
			return $total;
		}
		
		public function get_all_invoice($args)
		{
			$this->db->select(array('i.id as iid','i.client_id','i.idate','i.refno','ii.*'));
			$this->db->from('work_invoice as i');
			$this->db->join('work_invoice_items as ii','i.id=ii.inv_id');
			$this->db->where(array('i.status'=>1,'ii.status'=>1));
			
			if(isset($args['conditions']))
			{
				$this->db->where($args['conditions']);
			}
            if(isset($args['like']))
		    {
		        $this->db->like($args['like'],true,'');
		    }
			if(isset($args['group_by']))
			{
				$this->db->group_by($args['group_by']);
			}
			if(isset($args['numrows']))
			{
				return $this->db->count_all_results();
			}
			if(isset($args['order-by']))
			{
				$this->db->order_by($args['order_by'],$args['order']);
			}
			if(isset($args['limit']))
			{
				$this->db->limit($args['limit'],$args['offset']);
			}
			return $this->db->get()->result_array();
		}
		
		public function get_payment_report($args)
		{
			$this->db->select('*');
			$this->db->from('work_payments');
			$this->db->where('status',1);
			
			if(isset($args['conditions']))
			{
				$this->db->where($args['conditions']);
			}
            if(isset($args['like']))
		    {
		        $this->db->like($args['like'],true,'');
		    }
			if(isset($args['group_by']))
			{
				$this->db->group_by($args['group_by']);
			}
			if(isset($args['numrows']))
			{
				return $this->db->count_all_results();
			}
			if(isset($args['order-by']))
			{
				$this->db->order_by($args['order_by'],$args['order']);
			}
			if(isset($args['limit']))
			{
				$this->db->limit($args['limit'],$args['offset']);
			}
			return $this->db->get()->result_array();
		}
		
		public function get_payment_amount($eid)
		{
		    $total=0;
			$this->db->select_sum('amount');
			$this->db->from('work_payment_items');
			$this->db->where('pay_id',$eid);
			$row = $this->db->get()->row_array();
			
			if(!empty($row)){ $total = $row['amount']; }
			return $total;
		}
		
		public function get_all_payment($args)
		{
			$this->db->select(array('p.id as pid','p.client_id','p.pdate','p.refno','p.pmode','pi.*'));
			$this->db->from('work_payments as p');
			$this->db->join('work_payment_items as pi','p.id=pi.pay_id');
			$this->db->where(array('p.status'=>1,'pi.status'=>1));
			
			if(isset($args['conditions']))
			{
				$this->db->where($args['conditions']);
			}
            if(isset($args['like']))
		    {
		        $this->db->like($args['like'],true,'');
		    }
			if(isset($args['group_by']))
			{
				$this->db->group_by($args['group_by']);
			}
			if(isset($args['numrows']))
			{
				return $this->db->count_all_results();
			}
			if(isset($args['order-by']))
			{
				$this->db->order_by($args['order_by'],$args['order']);
			}
			if(isset($args['limit']))
			{
				$this->db->limit($args['limit'],$args['offset']);
			}
			return $this->db->get()->result_array();
		}
		
		public function get_invoice_due_report($args)
		{
			$this->db->select(array('i.*','sum(wi.amount) as amount'));
			$this->db->from('work_invoice as i');
			$this->db->join('work_invoice_items as wi','i.id=wi.inv_id');
			$this->db->where(array('i.status'=>1,'wi.status'=>1,'wi.payment_status'=>0));
			$this->db->group_by('i.id');
			
			if(isset($args['conditions']))
			{
				$this->db->where($args['conditions']);
			}
            if(isset($args['like']))
		    {
		        $this->db->like($args['like'],true,'');
		    }
			if(isset($args['numrows']))
			{
				return $this->db->count_all_results();
			}
			if(isset($args['order-by']))
			{
				$this->db->order_by($args['order_by'],$args['order']);
			}
			if(isset($args['limit']))
			{
				$this->db->limit($args['limit'],$args['offset']);
			}
			return $this->db->get()->result_array();
		}
	}
?>