<script src="https://ajax.googleapis.com/ajax/libs/jquery/1.6.1/jquery.min.js"></script>
<script>
    $(document).ready(function(e){
        var base_url = $('body').data('baseurl'); 
        var app_path = base_url+'ajax/';
        $("#ptype").change(function(){
            var ptype = $(this).val();
           
            $.ajax({ 
                type: "POST",
                url: app_path+"ajax/get_products",
                data: { ptype: ptype },
                dataType: "text",  
                cache:false,
                success: function(response){ 
                    
                    var data = jQuery.parseJSON(response);
                    $("#product").html('');
                    $("#product").append('<option value="">Select</option>')
                    $.each(data, function(key,value) { 
                        $("#product").append('<option value="'+key+'">'+value+'</option>')
                    }); 
                }
            });
        });
        $("#client").on('change',function(a){
            var cid = $(this).val();
            $.ajax({ 
                type: "POST",
                url: app_path+"ajax/get_branches",
                data: { cid: cid },
                dataType: "text",  
                cache:false,
                success: function(response){ 
                    var data = jQuery.parseJSON(response);
                    $("#branch").html('');
                    $("#branch").append('<option value="">Select</option>')
                    $.each(data, function(key,value) { 
                        $("#branch").append('<option value="'+value['id']+'">'+value['name']+'</option>')
                    });
                }
            });
        });
    });
</script>
<div class="card card-default card-outline">
	<form action="<?=base_url('estimate/add');?>" method="post">
        <div class="card-body">
            <div class="row">
                <div class="col-md-4">
                    <div class="form-group">
                        <label class="required">Client</label>
                        <?=form_dropdown("client_id",$clients,set_value('client_id',$client_id),"class='form-control select2bs4' id='client' required $disabled");?>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label class="required">Branch</label>
                        <?=form_dropdown("branch_id",$branches,set_value('branch_id',$branch_id),"class='form-control select2bs4' id='branch' required $disabled");?>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label class="required">Date</label>
                        <input type="date" class="form-control" name="edate" value="<?=$edate;?>" <?=$disabled;?>>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-md-8">
                    <div class="form-group">
                        <label>Remark</label>
                        <textarea class="form-control" name="remark" rows="2"></textarea>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-md-2">
                    <div class="form-group">
                        <label class="required">Type</label>
                        <?=form_dropdown("ptype",$ptypes,set_value('ptype'),"class='form-control' id='ptype' required");?>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label class="required">Product/Service</label>
                        <select class="form-control" name="product_id" id="product" required>
                            <option value="">Select</option>
                            <? foreach($products as $product){ ?>
                                <option value="<?=$product['id'];?>"><?=$product['name'];?></option>
                            <? } ?>
                        </select>
                    </div>
                </div>
                <div class="col-md-2">
                    <div class="form-group">
                        <label class="required">Cost</label>
                        <input type="text" class="form-control text-right" name="cost" required>
                    </div>
                </div>
                <div class="col-md-1">
                    <div class="form-group">
                        <label class="required">Validity</label>
                        <input type="text" class="form-control text-right" name="validity" required>
                    </div>
                </div>
                <div class="col-md-2">
                    <div class="form-group">
                        <label>Payment Type</label>
                        <?=form_dropdown("pay_type",$pay_types,set_value('pay_type'),"class='form-control'");?>
                    </div>
                </div>
                <div class="col-md-2">
                    <div class="form-group">
                        <label>Renewal charge</label>
                        <input type="text" class="form-control text-right" name="renewal">
                    </div>
                </div>
            </div>
            <div class="row">
              	<div class="col-md-12">
                    <div class="form-group">
                        <?=form_submit(array('name'=>'btn_add','class'=>'btn btn-primary float-right','value'=>'Add'));?>
                    </div>
                </div>
            </div>  
        </div>
    </form>
</div>
<? if(!empty($temp_data)){ ?>
    <div class="card card-default">
    	<form action="<?=base_url('estimate/add');?>" method="post">
            <div class="card-body">
                <div class="scroll">
                    <table class="table table-bordered">
                        <thead>
                        <tr>
                            <th>#</th>
                            <th>Type</th>
                            <th>Product</th>
                            <th>Remark</th>
                            <th>Cost</th>
                            <th>Validity</th>
                            <th>Renewal Cost</th>
                            <th>Actions</th>
                        </tr>
                        </thead>
                        <tbody>
                            <? $i=0; foreach($temp_data as $temp){ ?>
                                <tr>
                                    <td><?=++$i;?></td>
                                    <td><?=$ptypes[$temp['ptype']];?></td>
                                    <td><?=$this->product->get_name($temp['product_id']);?></td>
                                    <td><?=$temp['remark'];?></td>
                                    <td align="right"><?=$temp['cost'];?></td>
                                    <td align="right"><?=$temp['validity'];?></td>
                                    <td align="right"><?=$temp['renewal'];?></td>
                                    <td><a href="<?=base_url('estimate/delete_item/'.$temp['id']);?>"><i class="fas fa-times text-danger"></i></a></td>
                                </tr>
                            <? } ?>
                        </tbody>
                    </table>
                </div>
                <div class="row">
                  	<div class="col-md-12">
                        <div class="form-group">
                            <?=form_submit(array('name'=>'btn_save','class'=>'btn btn-primary float-right','value'=>'Save'));?>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
<? } ?>