<script src="https://ajax.googleapis.com/ajax/libs/jquery/1.6.1/jquery.min.js"></script>
<script>
    $( document ).ready(function() {
        
        $(".chksub").on('click',function(a){
            get_total();
        });
        $(".amount").on('keyup',function(a){
            get_total();
        });
    });
    
    function get_total()
    {
        $("#total").html('');
        var total=0;
        $(".chksub").each(function() {
            
            if($(this).is(':checked'))
            {
                var itid = $(this).val();
                var amt = parseFloat($("#amount"+itid).val());
                if(isNaN(amt)){ amt =0; }
                
                total += amt;
            }
        });
            
        total = total.toFixed(2);
            
        $("#total").html(total);
    }
    
    function isNumberKey(evt){
        var charCode = (evt.which) ? evt.which : evt.keyCode
        if (charCode > 31 && (charCode < 48 || charCode > 57))
            return false;
        return true;
    }
    
    function numcheck(id,amt,cur){ 
        
        amt = parseFloat(amt);
        cur = parseFloat(cur);
        
        if(isNaN(amt)){ amt=0; }
        if(isNaN(cur)){ cur=0; } 
        
        if(cur<0){ cur=0; }
        if(cur>amt){ cur=amt; }
        
        $("#amount"+id).val(cur);
    }
</script>
<div class="card card-default">
    <form action="<?= base_url('estimate/payment/'.$invoice_id);?>" method="post">
    	<div class="card-body">
            <div class="row">
                <div class="col-sm-6">
                    <div class="form-group row">
                        <label class="col-sm-4">Date</label>
                        <div class="col-sm-8"><?=dateFormat($invoice_det[0]['idate']);?></div>
                    </div>
                    <div class="form-group row">
                        <label class="col-sm-4">Client</label>
                        <div class="col-sm-8"><?=$this->client->get_name($invoice_det[0]['client_id']);?></div>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group row">
                        <label class="col-sm-4">Ref No</label>
                        <div class="col-sm-8"><?=$invoice_det[0]['refno'];?></div>
                    </div>
                    <div class="form-group row">
                        <label class="col-sm-4">Branch</label>
                        <div class="col-sm-8"><?=$this->client->get_branch_name($invoice_det[0]['branch_id']);?></div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-sm-12">
                    <div class="scroll">
                        <table class="table table-bordered">
                            <thead>
                            <tr>
                                <th>#</th>
                                <th></th>
                                <th>Type</th>
                                <th>Product</th>
                                <th>Cost</th>
                                <th>Due</th>
                                <th>Current Payment</th>
                                <th>Validity</th>
                                <th>Renewal Cost</th>
                                <th>Renewal Date</th>
                            </tr>
                            </thead>
                            <tbody>
                                <? $i=0; $total_cost=0; $total_due=0; foreach($invoice_det as $invoice){ $i++; 
                                    $itid = $invoice['id']; $pstatus="Paid"; $pclass="text-success";
                                    $cost = $invoice['cost'];
                                    $due = $this->estimate->get_due($itid); 
                                    $total_cost += $cost; $total_due += $due; ?>
                                    <tr>
                                        <td><?=$i;?></td>
                                        <td align="center">
                                            <? if($due>0){ $pstatus="Not Paid"; $pclass="text-danger"; ?>
                                                <div class="icheck-primary d-inline"><input type="checkbox" id="sub<?=$itid;?>" class="chksub" name="posted[]" value="<?=$itid;?>"><label for="sub<?=$itid;?>"></label></div>
                                            <? } ?>
                                            <input type="hidden" name="product<?=$itid;?>" id="product<?=$itid;?>" value="<?=$invoice['product_id'];?>">
                                        </td>
                                        <td align="center"><?=$ptypes[$invoice['ptype']];?></td>
                                        <td><?=$this->product->get_name($invoice['product_id']);?></td>
                                        <td align="right"><?=numberFormat($cost);?></td>
                                        <td align="right"><?=numberFormat($due);?></td>
                                        <td align="center">
                                            <? if($due>0){ ?>
                                                <input type="text" class="form-control text-right amount" name="amount<?=$itid;?>" id="amount<?=$itid;?>" value="<?=$due;?>" onkeypress="return isNumberKey(event)" onkeyup="numcheck('<?=$itid;?>','<?=$due;?>',this.value)">
                                            <? }else{ ?>
                                                <p class="text-success">Paid</p>
                                            <? } ?>
                                        </td>
                                        <td align="center"><?=$invoice['validity'].' '.$invoice['pay_type'];?></td>
                                        <td align="right"><?=numberFormat($invoice['renewal']);?></td>
                                        <td align="center"><?=dateFormat($invoice['renew_date']);?></td>
                                    </tr>
                                <? } ?>
                            </tbody>
                            <tfoot>
                                <tr>
                                    <td colspan="4" align="center"><b>Grand Total</b></td>
                                    <td align="right"><b><?=numberFormat($total_cost);?><b></td>
                                    <td align="right"><b><?=numberFormat($total_due);?><b></td>
                                    <td align="right"><b><span id="total">0.00</span></b></td>
                                    <td colspan="3"></td>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-sm-3">
                    <div class="form-group">
                        <label class="required">Date</label>
                        <input type="date" class="form-control" name="pdate" value="<?=date('Y-m-d');?>" required>
                    </div>
                </div>
                <div class="col-sm-2">
                    <div class="form-group">
                        <label>Bill No</label>
                        <input type="text" class="form-control" name="bill_no" value="<?=$billnum; ?>">
                    </div>
                </div>
                <div class="col-sm-3">
                    <div class="form-group">
                        <label class="required">Payment Mode</label>
                        <select class="form-control" name="pmode" id="pmode" required>
                            <option value="">select</option>
                            <? foreach($payment_modes as $key => $value){?>
                                <option value="<?=$key;?>"><?=$value;?></option>
                            <? } ?>
                        </select>
                    </div>
                </div>
            </div>
            <div class="row">
              	<div class="col-md-12">
                    <div class="form-group">
                        <?=form_submit(array('name'=>'btn_save','class'=>'btn btn-primary float-right','value'=>'Pay Now'));?>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>