<div class="card card-default">
	<form action="<?= base_url('estimate/report');?>" method="post">
        <div class="card-body">
            <div class="row">
              	<div class="col-md-4">
                    <div class="form-group">
                        <label>Client</label>
                        <?=form_dropdown("client_id",$clients,set_value('client_id',$client_id),"class='form-control select2bs4'");?>
                    </div>
                </div>
                <div class="col-md-2">
                    <div class="form-group">
                        <label>From Date</label>
                        <input type="date" class="form-control" name="fdate" id="fdate" value="<?=$fdate;?>">
                    </div>
                </div>
                <div class="col-md-2">
                    <div class="form-group">
                        <label>To Date</label>
                        <input type="date" class="form-control" name="edate" id="edate" value="<?=$edate;?>">
                    </div>
                </div>
                <div class="col-md-4">
                    <label>Status</label>
                    <div class="row">
                        <div class="col-md-9">
                            <div class="form-group">
                                <select class="form-control" name="estatus" id="estatus">
                                    <option value="">Select</option>
                                    <option value="0">Pending</option>
                                    <option value="1">Invoice</option>
                                    <option value="2">Rejected</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <?=form_submit(array('name'=>'btn_get','class'=>'btn btn-primary','id'=>'btn-filter','value'=>'Go'));?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>
<? if(!empty($estimates)){ ?>
    <div class="card card-default">
        <div class="card-body">
            <div class="row">
                <div class="col-12">
                    <div class="scroll-x">
                        <table id="table" class="table table-bordered">
                            <thead>
                            <tr>
                                <th>#</th>
                                <th>Date</th>
                                <th>Client</th>
                                <th>Branch</th>
                                <th>Amount</th>
                                <th>Status</th>
                                <th>Actions</th>
                            </tr>
                            </thead>
                            <tbody>
                                <? $i=$total=0; foreach($estimates as $estimate){ 
                                    $amount = $this->estimate->get_estimate_amount($estimate['id']);
                                    $total += $amount;
                                    $eclass=""; $estatus="";
                                    if($estimate['estatus']=='0'){ $eclass="badge-info"; $estatus="Pending"; }
                                    else if($estimate['estatus']=='1'){ $eclass="badge-success"; $estatus="Invoice"; }
                                    else if($estimate['estatus']=='2'){ $eclass="badge-danger"; $estatus="Rejected"; }?>
                                    <tr>
                                        <td align="center"><?=++$i;?></td>
                                        <td align="center"><?=dateFormat($estimate['edate']);?></td>
                                        <td><?=$this->client->get_name($estimate['client_id']);?></td>
                                        <td><?=$this->client->get_branch_name($estimate['branch_id']);?></td>
                                        <td align="right"><?=numberFormat($amount);?></td>
                                        <td align="center"><span class="badge <?=$eclass;?>"><?=$estatus;?></span></td>
                                        <td align="center">
                                            <? if($estimate['estatus']=='0'){ ?>
                                                <a href="<?=base_url();?>estimate/invoice/<?=$estimate['id'];?>"><i class="fas fa-file-invoice text-lg text-success" title="Generate Invoice"></i></a>&nbsp;&nbsp;&nbsp;
                                                <a href="<?=base_url();?>estimate/reject/<?=$estimate['id'];?>"><i class="fas fa-file-excel text-lg text-danger" title="Reject Estimate"></i></a>&nbsp;&nbsp;&nbsp;
                                            <? } ?>
                                            <a href="<?=base_url();?>estimate/estimate_pdf/<?=$estimate['id'];?>" target="blank_"><i class="fas fa-file-pdf text-lg text-danger" title="Estimate PDF"></i></a>&nbsp;&nbsp;&nbsp;
                                            <a href="<?=base_url();?>estimate/view/<?=$estimate['id'];?>"><i class="fas fa-search-plus text-lg text-primary" title="View Estimate"></i></a>&nbsp;&nbsp;&nbsp;
                                            <a href="<?=base_url();?>estimate/delete/<?=$estimate['id'];?>" onClick="return confirm(\'Are you sure you want to delete ?\');"><i class="fas fa-times text-lg text-danger" title="Delete Estimate"></i></a>
                                        </td>
                                    </tr>
                                <? } ?>
                            </tbody>
                            <tfoot>
                                <tr>
                                    <td align="center" colspan="4"><b>Total</b></td>
                                    <td align="right"><b><?=numberFormat($total);?></b></td>
                                    <td colspan="2"></td>
                                </tr>
                                <tr>
                                    <td colspan="6"><b>In Words : </b><?=$this->to_words->num_to_words($total);?></td>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
<? } ?>