<div class="card card-default">
	<form action="<?=base_url('expense/report');?>" method="post">
        <div class="card-body">
            <div class="row">
              	<div class="col-md-3">
                    <div class="form-group">
                        <label>From Date</label>
                        <input type="date" class="form-control" name="fdate" value="<?=$fdate;?>">
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label>To Date</label>
                        <input type="date" class="form-control" name="tdate" value="<?=$tdate;?>">
                    </div>
                </div>
                
                <div class="col-md-6">
                    <label>Status</label>
                    <div class="row">
              	        <div class="col-md-6">
                            <div class="form-group">
                                <?=form_dropdown("status",$statuses,set_value('status',$status),"class='form-control select2bs4' style='width:100%;'");?>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <?=form_submit(array('name'=>'btn_get','class'=>'btn btn-primary','value'=>'Go'));?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>
<? if(!empty($expenses)){ ?>
    <div class="card card-default">
        <div class="card-body">
            <div class="row">
                <div class="col-12">
                    <div class="scroll-x">
                        <table id="table" class="table table-bordered">
                            <thead>
                            <tr>
                                <td align="center"><b>#</b></td>
                                <td align="center"><b>Date</b></td>
                                <td align="center"><b>Client</b></td>
                                <td align="center"><b>Remarks</b></td>
                                <td align="center"><b>Amount</b></td>
                                <td align="center"><b>Created By</b></td>
                                <td align="center"><b>Status</b></td>
                                <td align="center"><b>Actions</b></td>
                            </tr>
                            </thead>
                            <tbody>
                                <? $i=$total=0; foreach($expenses as $expense){ 
                                    $total += $expense['amount'];
                                    $eclass=""; $estatus="";
                                    if($expense['estatus']=='1'){ $eclass="badge-info"; $estatus="Pending"; }
                                    else if($expense['estatus']=='2'){ $eclass="badge-success"; $estatus="Approved"; }
                                    else if($expense['estatus']=='3'){ $eclass="badge-danger"; $estatus="Rejected"; } ?>
                                    <tr>
                                        <td align="center"><?=++$i;?></td>
                                        <td align="center"><?=dateFormat($expense['cdate']);?></td>
                                        <td><?=$expense['client'];?></td>
                                        <td><?=$expense['remarks'];?></td>
                                        <td align="right"><?=numberFormat($expense['amount']);?></td>
                                        <td align="center"><?=$this->dms->get_staff_name($expense['created_by']);?></td>
                                        <td align="center"><span class="badge <?=$eclass;?>"><?=$estatus;?></span></td>
                                        <td align="center">
                                            <? if($expense['estatus']=='1'){ ?>
                                                <a href="<?=base_url();?>expense/approve/<?=$expense['id'];?>" title="Approve"><i class="fas fa-file-invoice text-lg text-success"></i></a>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                                <a href="<?=base_url();?>expense/reject/<?=$expense['id'];?>" title="Reject"><i class="fas fa-file-excel text-lg text-danger"></i></a>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                            <? } ?>
                                            <a href="<?=base_url();?>expense/view/<?=$expense['id'];?>" title="View"><i class="fas fa-search-plus text-lg text-primary"></i></a>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                            <a href="<?=base_url();?>expense/delete/<?=$expense['id'];?>" title="Delete" onClick="return confirm(\'Are you sure you want to delete ?\');"><i class="fas fa-times text-lg text-danger"></i></a>
                                        </td>
                                    </tr>
                                <? } ?>
                            </tbody>
                            <tfoot>
                                <tr>
                                    <td align="center" colspan="4"><b>Total</b></td>
                                    <td align="right"><b><?=numberFormat($total);?></b></td>
                                    <td align="center" colspan="3"></td>
                                </tr>
                                <tr>
                                    <td colspan="8"><b>In Words : </b><?=$this->to_words->num_to_words($total);?></td>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
<? } ?>