<div class="card card-default">
	<form action="<?=base_url('lead/assigned');?>" method="post">
        <div class="card-body">
            <div class="row">
              	<div class="col-md-3">
                    <div class="form-group">
                        <label>Lead Type</label>
                        <?=form_dropdown("ltype",$ltypes,set_value('ltype',$ltype),"class='form-control select2bs4' id='ltype' style='width:100%;'");?>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label>From Date</label>
                        <input type="date" class="form-control" name="fdate" id="fdate" value="<?=$fdate;?>">
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label>To Date</label>
                        <input type="date" class="form-control" name="tdate" id="tdate" value="<?=$tdate;?>">
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label>Collected By</label>
                        <?=form_dropdown("collected",$users,set_value('collected',$collected),"class='form-control select2bs4' id='collect' style='width:100%;'");?>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-md-3">
                    <div class="form-group">
                        <label>Status</label>
                        <?=form_dropdown("status",$lstatus_list,set_value('status',$status),"class='form-control select2bs4' id='status' style='width:100%;'");?>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-md-12">
                    <?= form_submit(array('name'=>'btn_get','class'=>'btn btn-primary float-right','id'=>'btn-filter','value'=>'Filter'));?>
                </div>    
            </div>
        </div>
    </form>
</div>
<div class="row">
    <div class="col-12">
        <div class="card card-default">
            <div class="card-body">
                <div class="form-group row">
                    <div class="col-12 text-right">
                        <a href="<?=base_url();?>excel/lead_excel/assigned_report/sid/<?=$uid;?><?=$redirect;?>" target="blank_"><i class="fas fa-file-excel text-xl text-success"></i></a>
                    </div>
                </div>
                <div class="row">
                    <? foreach($lstatuses as $lid => $ldet){ ?>
                        <div class="col-2">
                            <div class="form-group">
                                <div class="square" style="background-color:<?=$ldet['color'];?>;"></div> <div class="indic">   <?=$ldet['remark'];?> - <? if(isset($count_array[$lid])){ ?><?=$count_array[$lid];?><? }else{ ?>0<? } ?></div>
                            </div>
                        </div>
                    <? } ?>
                </div>
                <div class="scroll-x">
                    <table id="table" class="table table-bordered">
                        <thead>
                        <tr>
                            <th>#</th>
                            <th>Ref No</th>
                            <th>Date</th>
                            <th>Type</th>
                            <th>Name</th>
                            <th>Mobile</th>
                            <th>Followup</th>
                            <th>Status</th>
                            <th>Percentage</th>
                            <th>Remaining</th>
                            <th>Principal</th>
                            <th>Manager</th>
                            <th>Location</th>
                            <th>Last Update</th>
                            <th>Last Remark</th>
                            <th>Whatsapp</th>
                            <th>Email</th>
                            <th>Collected By</th>
                        </tr>
                        </thead>
                        <tbody>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<script src="https://ajax.googleapis.com/ajax/libs/jquery/1.6.1/jquery.min.js"></script>
<script type="text/javascript">
    $(document).ready(function() {
        $('#table').DataTable({ 
            "processing": true,
            "serverSide": true,
            "order": [],
            "pagingType": "full_numbers",
            "ajax": {
                "url": "<?=base_url('lead/ajax_assigned_list')?>",
                "type": "POST",
                "data": function ( data ) {
                    data.ltype = $('#ltype').val();
                    data.fdate = $('#fdate').val();
                    data.tdate = $('#tdate').val();
                    data.collect = $('#collect').val();
                    data.stat = $('#status').val();
                }
            },
            "columnDefs": [
                { 
                    "targets": [ 0,6,9 ],
                    "orderable": false,
                },
            ],
            "createdRow": function( row, data, dataIndex){
                
                $(row).css({'background-color': data[19] });
            }
        });
        
        $.fn.DataTable.ext.pager.numbers_length = 10;
     
        $('#btn-filter').click(function(){
            table.ajax.reload();
        });
        
        $('#btn-reset').click(function(){
            $('#form-filter')[0].reset();
            table.ajax.reload();
        });
    });
    
    function setlstatus(lid,rid){
        $.ajax({
            url : "<?=base_url('lead/set_lstatus')?>",
            data : { lid:lid, rid:rid },
            type : "POST",
			success:function(data){ 
				location.reload();
			}
		});
	}
	
	function update_principal(lid,str){
        $.ajax({
            url : "<?=base_url('lead/update_principal')?>",
            data : { lid:lid, str:str },
            type : "POST",
			success:function(data){ 
				location.reload();
			}
		});
	}
	
	function update_manager(lid,str){
        $.ajax({
            url : "<?=base_url('lead/update_manager')?>",
            data : { lid:lid, str:str },
            type : "POST",
			success:function(data){ 
				location.reload();
			}
		});
	}
</script>