<script src="https://ajax.googleapis.com/ajax/libs/jquery/1.6.1/jquery.min.js"></script>
<script>
    $(document).ready(function(e){
        var base_url = $('body').data('baseurl'); 
        var app_path = base_url+'ajax/';
        $(".cstatus").click(function(){
            var cstatus = $(this).val();
            if(cstatus=='0'){
                $("#remark").val('Not Attended');
            }
        });
        
        $("#percentage").on('keyup, change',function(){
            var perc = parseFloat($(this).val());
            if(perc !='' && perc!=null){
                if(perc < 0){ perc = 0; }
                if(perc > 100){ perc = 100; }
                $("#percentage").val(perc);
            }
        });
    });
</script>
<div class="card card-primary card-outline">
    <div class="card-header">
        <h5>Lead Details</h5>
        <div class="card-tools">
            <button type="button" class="btn btn-sm btn-danger" onclick="window.close();">Back</button>
        </div>
    </div>
	<div class="card-body">
        <form action="<?=base_url('lead/save_follow');?>" method="post">
            <input type="hidden" id="lid" name="lid" value="<?=$lead_det['id'];?>">
            <div class="row">
                <div class="col-sm-5">
                    <div class="form-group row">
                        <label class="col-sm-4">Ref No</label>
                        <div class="col-sm-8"><?=$lead_det['refno'];?></div>
                    </div>
                    <div class="form-group row">
                        <label class="col-sm-4">Lead Type</label>
                        <div class="col-sm-8"><?=$ltypes[$lead_det['ltype']];?></div>
                    </div>
                    <div class="form-group row">
                        <label class="col-sm-4">Location</label>
                        <div class="col-sm-8"><?=$lead_det['location'];?></div>
                    </div>
                    <div class="form-group row">
                        <label class="col-sm-4">Landline</label>
                        <div class="col-sm-8"><?=$lead_det['landline'];?></div>
                    </div>
                     <div class="form-group row">
                        <label class="col-sm-4">Principal</label>
                        <div class="col-sm-8"><?=$lead_det['principal'];?></div>
                    </div>
                    <div class="form-group row">
                        <label class="col-sm-4">Email ID</label>
                        <div class="col-sm-8"><?=$lead_det['email'];?></div>
                    </div>
                    <div class="form-group row">
                        <label class="col-sm-4">Collected By</label>
                        <div class="col-sm-8"><?=$this->user->get_username($lead_det['collected_by']);?></div>
                    </div>
                    <div class="form-group row">
                        <label class="col-sm-4">Software Status</label>
                        <div class="col-sm-8">
                            <select class="form-control" name="sstatus">
                                <option value="0">Select</option>
                                <option value="1" <? if($lead_det['software_status']=='1'){ ?>selected<? } ?> >Yes</option>
                                <option value="2" <? if($lead_det['software_status']=='2'){ ?>selected<? } ?> >No</option>
                            </select>
                        </div>
                    </div>
                    <div class="form-group row">
                        <label class="col-sm-4">Deadline</label>
                        <div class="col-sm-8"><input type="datetime-local" class="form-control" name="deadline" value="<?=$lead_det['deadline'] ?? '';?>"></div>
                    </div>
                </div>
                <div class="col-sm-2"></div>
                <div class="col-sm-5">
                    <div class="form-group row">
                        <label class="col-sm-4">Date</label>
                        <div class="col-sm-8"><?=dateFormat($lead_det['cdate']);?></div>
                    </div>
                    <div class="form-group row">
                        <label class="col-sm-4">Name</label>
                        <div class="col-sm-8"><?=$lead_det['cname'];?></div>
                    </div>
                    <div class="form-group row">
                        <label class="col-sm-4">Mobile No.</label>
                        <div class="col-sm-8"><?=$lead_det['mobile'];?></div>
                    </div>
                    <div class="form-group row">
                        <label class="col-sm-4">Whatsapp</label>
                        <div class="col-sm-8"><?=$lead_det['whatsapp'];?></div>
                    </div>
                    <div class="form-group row">
                        <label class="col-sm-4">Lead Source</label>
                        <div class="col-sm-8"><?=$lead_det['source'];?></div>
                    </div>
                    <div class="form-group row">
                        <label class="col-sm-4">Assign To</label>
                        <div class="col-sm-8"><?=$this->user->get_username($lead_det['assigned_to']);?></div>
                    </div>
                    <div class="form-group row">
                        <label class="col-sm-4">Status</label>
                        <div class="col-sm-8">
                            <select class="form-control" name="lstatus">
                                <? foreach($status_array as $skey => $svalue){ ?>
                                    <option value="<?=$skey;?>" <? if($lead_det['lstatus']==$skey){ ?>selected<? } ?> ><?=$svalue;?></option>
                                <? } ?>
                            </select>
                        </div>
                    </div>
                    <div class="form-group row">
                        <label class="col-sm-4">Percentage</label>
                        <div class="col-sm-8">
                            <input type="number" class="form-control" id="percentage" name="percentage" min="0" max="100" step="1" value="<?= $lead_det['percentage'] ?? 0; ?>">
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-12">
                    <div class="form-group">
                        <?=form_submit(array('name'=>'btn_upd','class'=>'btn btn-primary float-right','value'=>'Save'));?>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>
<div class="card card-primary card-outline">
    <form action="<?=base_url('lead/followup/'.$lead_id);?>" method="post">
        <div class="card-body">
            <div class="row">
                <div class="col-md-3">
                    <div class="form-group">
                        <label class="required">Date</label>
                        <input type="date" class="form-control" name="pdate" value="<?=date('Y-m-d');?>" required>
                    </div>
                </div>
                <div class="col-md-2">
                    <label class="required">Call Status</label>
                    <div class="form-group clearfix">
                        <div class="icheck-success d-inline">
                            <input type="radio" class="cstatus" id="cstatus1" name="call_status" value="1" checked>
                            <label for="cstatus1">Attended</label>
                        </div>
                        <div class="icheck-success d-inline">
                            <input type="radio" class="cstatus" id="cstatus2" name="call_status" value="0">
                            <label for="cstatus2">Not Attended</label>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label class="required">Remarks</label>
                        <textarea class="form-control" id="remark" name="remarks" required></textarea>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label>Followup Date</label>
                        <div class="row">
                            <div class="col-md-8">
                                <input type="date" class="form-control" name="fdate">
                            </div>
                            <div class="col-md-4">
                                <?=form_submit(array('name'=>'btn_save','class'=>'btn btn-primary','value'=>'Save'));?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>
<? if(!empty($follow_det)){ ?>
    <div class="card card-primary card-outline">
        <div class="card-header">
            <h5>Lead Progress</h5>
        </div>
    	<div class="card-body">
            <div class="row">
                <div class="col-sm-12">
                    <div class="scroll">
                        <table class="table table-head-fixed text-nowrap">
                            <thead>
                            <tr>
                                <th>Date</th>
                                <th>Remarks</th>
                                <th>Staff</th>
                                <th>Followup Date</th>
                            </tr>
                            </thead>
                            <tbody>
                            <? foreach($follow_det as $follow){ ?>
                                <tr>
                                    <td><?=dateFormat($follow['pdate']);?></td>
                                    <td><?=$follow['remarks'];?></td>
                                    <td><?=$this->user->get_username($follow['staff']);?></td>
                                    <td><? if($follow['fdate']!='0000-00-00'){ ?><?=date('d/m/Y',strtotime($follow['fdate']));?><? } ?></td>
                                </tr>
                            <? } ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
<? } ?>