<div class="card card-default">
    <div class="card-body">
        <div class="row">
            <div class="col-12 col-sm-3">
                <div class="form-group">
                    <label for="fdate">From Date</label>
                    <input type="date" class="form-control" id="fdate" value="<?=date('Y-m-d');?>">
                </div>
            </div>
            <div class="col-12 col-sm-3">
                <div class="form-group">
                    <label for="tdate">To Date</label>
                    <input type="date" class="form-control" id="tdate" value="<?=date('Y-m-d');?>">
                </div>
            </div>
            <div class="col-12 col-sm-3">
                <div class="form-group">
                    <label for="ltype">Lead Type</label>
                    <select class="form-control select2bs4" id="ltype">
                        <option value="">Select</option>
                        <? foreach($ltypes as $key => $value){ ?>
                            <option value="<?=$key;?>"><?=$value;?></option>
                        <? } ?>
                    </select>
                </div>
            </div>
            <div class="col-12 col-sm-3">
                <div class="form-group">
                    <label for="status">Status</label>
                    <select class="form-control" id="status">
                        <option value="">Select</option>
                        <option value="pending">Pending</option>
                        <option value="sent">Sent</option>
                        <option value="failed">Failed</option>
                    </select>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="form-group">
                    <button type="button" class="btn btn-primary float-right" id="getData">Filter</button>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="card card-default">
    <div class="card-body">
        <div class="scroll">
            <table id="mail-report" class="table table-bordered">
                <thead>
                <tr>
                    <th>#</th>
                    <th>Lead Type</th>
                    <th>Subject</th>
                    <th>Created By</th>
                    <th>Created On</th>
                    <th>Status</th>
                </tr>
                </thead>
                <tbody>
                </tbody>
            </table>
        </div>
    </div>
</div>
<script src="https://ajax.googleapis.com/ajax/libs/jquery/1.6.1/jquery.min.js"></script>
<script>
    $( document ).ready(function() {
		var table = $('#mail-report').DataTable({ 
            "processing": true,
            "searching": true,
            "serverSide": true,
            "stateSave": true,
            "order": [],
            "ajax": {
                "url": "<?=base_url('MailSending/ltype_report_ajax')?>",
                "type": "POST",
                "data": function(data){
                    data.fdate = $('#fdate').val();
                    data.tdate = $('#tdate').val();
                    data.ltype = $('#ltype').val();
                    data.status = $('#status').val();
                }
            },
            "columnDefs": [
                { 
                    "targets": [ 3 ],
                    "orderable": false,
                },
            ],
        });
        
        setInterval( function () {
            table.ajax.reload( null, false );
        }, 30000 );
        
        $('#getData').click(function(){
            table.draw();
        });
    });
</script>