<? if(!empty($years)){ ?>
    <div class="row">
        <div class="col-12">
            <div class="card card-default">
                <div class="card-header">
                    <h3 class="card-title"><i class="fas fa-chart-pie mr-1"></i> Payments</h3>
                    <div class="card-tools">
                        <ul class="nav nav-pills ml-auto">
                            <li class="nav-item">
                                <a class="nav-link active" href="#yearly-chart" data-toggle="tab">Yearly</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" href="#monthly-chart" data-toggle="tab">Monthly</a>
                            </li>
                            <li class="nav-item" style="padding-left:3px;">
                                <select class="form-control" id="year">
                                    <option value="">Year</option>
                                    <? foreach($year_list as $k => $v){ ?>
                                        <option value="<?=$k;?>"><?=$v;?></option>
                                    <? } ?>
                                </select>
                            </li>
                        </ul>
                    </div>
                </div>
                <div class="card-body">
                    <div class="tab-content p-0">
                        <div class="chart tab-pane active" id="yearly-chart" style="position: relative; height: 300px;">
                            <canvas id="yearly-chart-canvas" height="300" style="height: 300px;"></canvas>
                        </div>
                        <div class="chart tab-pane" id="monthly-chart" style="position: relative; height: 300px;">
                            <canvas id="monthly-chart-canvas" height="300" style="height: 300px;"></canvas>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<? } ?>
<script src="<?=base_url().'plugins/chart.js/Chart.min.js';?>"></script>
<script>
  	$(function () {
		var ticksStyle = {
    		fontColor: '#495057',
    		fontStyle: 'bold'
  		}

  		var mode      = 'index'
  		var intersect = true

		var $yearlyChart = $('#yearly-chart-canvas')
  		var yearlyChart  = new Chart($yearlyChart, {
    		type   : 'bar',
    		data   : {
      			labels  : <?=json_encode($years);?>,
      			datasets: [
        			{
          				backgroundColor: '#28a745',
          				borderColor    : '#28a745',
          				data           : <?=json_encode($yincome);?>
        			},
        			{
          				backgroundColor: '#f44336',
          				borderColor    : '#f44336',
          				data           : <?=json_encode($yexpense);?>
        			}
      			]
    		},
    		options: {
      			maintainAspectRatio: false,
      			tooltips           : {
        			mode     : mode,
        			intersect: intersect
      			},
      			hover              : {
        			mode     : mode,
        			intersect: intersect
      			},
      			legend             : {
        			display: false
      			},
      			scales             : {
        			yAxes: [{
          				gridLines: {
            				display      : true,
            				lineWidth    : '4px',
            				color        : 'rgba(0, 0, 0, .2)',
            				zeroLineColor: 'transparent'
          				},
          				ticks    : $.extend({
            				beginAtZero: true,
							stepSize: 100000
           
          				}, ticksStyle)
        			}],
        			xAxes: [{
          				display  : true,
          				gridLines: {
            				display: false
          				},
          				ticks    : ticksStyle
        			}]
      			}
    		}
  		});
  	})
  	
  	$(document).ready(function(){
  	    
  	    var base_url = $('body').data('baseurl'); 
        var app_path = base_url+'ajax/';
  	   
        $("#year").on('change', function(){
            
            var year = $(this).val(); 
            $("#monthly-chart-canvas").remove();
            $("#monthly-chart").append('<canvas id="monthly-chart-canvas" height="300" style="height: 300px;"></canvas>');

            $.ajax({
                type: "POST",
                url: app_path+"ajax/get_month_pay",
                data: { year: year },
                dataType: "text",  
                cache:false,
                success: function(response){
                    
                    var data = jQuery.parseJSON(response);
                    
                    var ticksStyle = {
                		fontColor: '#495057',
                		fontStyle: 'bold'
              		}
            
              		var mode      = 'index'
              		var intersect = true
              		
                    var $monthlyChart = $('#monthly-chart-canvas')
              		var monthlyChart = new Chart($monthlyChart, {
                		type   : 'bar',
                		data   : {
                  			labels  : data[0],
                  			datasets: [
                    			{
                      				backgroundColor: '#28a745',
                      				borderColor    : '#28a745',
                      				data           : data[1]
                    			},
                    			{
                      				backgroundColor: '#f44336',
                      				borderColor    : '#f44336',
                      				data           : data[2]
                    			}
                  			]
                		},
                		options: {
                  			maintainAspectRatio: false,
                  			tooltips           : {
                    			mode     : mode,
                    			intersect: intersect
                  			},
                  			hover              : {
                    			mode     : mode,
                    			intersect: intersect
                  			},
                  			legend             : {
                    			display: false
                  			},
                  			scales             : {
                    			yAxes: [{
                      				gridLines: {
                        				display      : true,
                        				lineWidth    : '4px',
                        				color        : 'rgba(0, 0, 0, .2)',
                        				zeroLineColor: 'transparent'
                      				},
                      				ticks    : $.extend({
                        				beginAtZero: true,
            							stepSize: 100000
                       
                      				}, ticksStyle)
                    			}],
                    			xAxes: [{
                      				display  : true,
                      				gridLines: {
                        				display: false
                      				},
                      				ticks    : ticksStyle
                    			}]
                  			}
                		}
              		});
                }
            });
        });
  	});
</script>