<div class="card card-primary card-outline">
    <div class="card-header">
        <h3 class="card-title">Work Details</h3>
    </div>
	<div class="card-body">
        <div class="row">
            <div class="col-sm-6">
                <div class="row">
                    <label class="col-sm-4 col-form-label">Date</label>
                    <label class="col-sm-1 col-form-label">:</label>
                    <div class="col-sm-6 col-form-label"><?=dateFormat($work_det['cdate']);?></div>
                    <label class="col-sm-1 col-form-label"></label>
                </div>
                <div class="row">
                    <label class="col-sm-4 col-form-label">Contacted Person</label>
                    <label class="col-sm-1 col-form-label">:</label>
                    <div class="col-sm-6 col-form-label"><?=$work_det['person'];?></div>
                    <label class="col-sm-1 col-form-label"></label>
                </div>
            </div>
            <div class="col-sm-6">
                <div class="row">
                    <label class="col-sm-4 col-form-label">Client</label>
                    <label class="col-sm-1 col-form-label">:</label>
                    <div class="col-sm-6 col-form-label"><?=$this->work_lib->get_client_name($work_det['client_id']);?></div>
                    <label class="col-sm-1 col-form-label"></label>
                </div>
                <div class="form-group row">
                    <label class="col-sm-4 col-form-label">Contact No.</label>
                    <label class="col-sm-1 col-form-label">:</label>
                    <div class="col-sm-6 col-form-label"><?=$work_det['contact_no'];?></div>
                    <label class="col-sm-1 col-form-label"></label>
                </div>
            </div>
        </div>
        <div class="row">
            <label class="col-sm-2 col-form-label">Description</label>
            <label class="col-sm-1 col-form-label">:</label>
            <div class="col-sm-8 col-form-label"><?=$work_det['description'];?></div>
            <label class="col-sm-1 col-form-label"></label>
        </div>
        <div class="row">
            <div class="col-sm-6">
                <div class="row">
                    <label class="col-sm-4 col-form-label">Work Type</label>
                    <label class="col-sm-1 col-form-label">:</label>
                    <div class="col-sm-6 col-form-label"><? if($work_det['ptype']=='1'){ echo "Paid"; }else if($work_det['ptype']=='0'){ echo "Non-Paid"; } ?></div>
                    <label class="col-sm-1 col-form-label"></label>
                </div>
                <div class="row">
                    <label class="col-sm-4 col-form-label">Allowed Time</label>
                    <label class="col-sm-1 col-form-label">:</label>
                    <div class="col-sm-6 col-form-label"><?=$work_det['wtime'];?> Min.</div>
                    <label class="col-sm-1 col-form-label"></label>
                </div>
                <div class="row"> 
                    <label class="col-sm-4 col-form-label">Remarks</label>
                    <label class="col-sm-1 col-form-label">:</label>
                    <div class="col-sm-6 col-form-label"><?=$work_det['remarks'];?></div>
                    <label class="col-sm-1 col-form-label"></label>
                </div>
            </div>
            <div class="col-sm-6">
                <div class="row"> 
                    <label class="col-sm-4 col-form-label">Amount</label>
                    <label class="col-sm-1 col-form-label">:</label>
                    <div class="col-sm-6 col-form-label"><?=$work_det['pamount'];?></div>
                    <label class="col-sm-1 col-form-label"></label>
                </div>
                <div class="row">
                    <label class="col-sm-4 col-form-label">Status</label>
                    <label class="col-sm-1 col-form-label">:</label>
                    <div class="col-sm-6 col-form-label">
                        <? $status_array = array('0'=>'Ongoing','1'=>'Pending','2'=>'Completed','3'=>'Terminated');?>
                        <?=$status_array[$work_det['wstatus']];?>
                    </div>
                    <label class="col-sm-1 col-form-label"></label>
                </div>
                <div class="row">
                    <label class="col-sm-4 col-form-label">Attachment</label>
                    <label class="col-sm-1 col-form-label">:</label>
                    <div class="col-sm-6 col-form-label">
                        <? if($work_det['file']!=''){ ?><a href="<?=base_url().'assets/files/work/attachment/'.$work_det['file'];?>" target="blank_">View</a><? } ?>
                    </div>
                    <label class="col-sm-1 col-form-label"></label>
                </div>
                <div class="row">
                    <label class="col-sm-4 col-form-label">Audio</label>
                    <label class="col-sm-1 col-form-label">:</label>
                    <div class="col-sm-6 col-form-label">
                        <? if($work_det['audio']!=''){ ?><a href="<?=base_url().'assets/files/work/audio/'.$work_det['audio'];?>" target="blank_">View</a><? } ?>
                    </div>
                    <label class="col-sm-1 col-form-label"></label>
                </div>
            </div>
        </div>
    </div>    
</div>
<div class="card card-outline card-success">
    <div class="card-header">
        <h3 class="card-title">Work Updates</h3>
    </div>
	<div class="card-body">
	    <? foreach($work_assigns as $work_assign ){
	        $work_updates = $this->work_lib->work_staff_updates($work_id,$work_assign['staff_id']);
?>
            <div class="row">
                <div class="col-sm-6">
                    <div class="row">
                        <label class="col-sm-4 col-form-label">Assigned On</label>
                        <label class="col-sm-1 col-form-label">:</label>
                        <div class="col-sm-6 col-form-label"><?=dateFormat($work_assign['adate']);?></div>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="row">
                        <label class="col-sm-4 col-form-label">Assigned To</label>
                        <label class="col-sm-1 col-form-label">:</label>
                        <div class="col-sm-6 col-form-label"><?=$this->dms->get_staff_name($work_assign['staff_id']);?></div>
                    </div>
                </div>
            </div>
            <? if(!empty($work_updates)){ ?>
                <div class="row">
                    <div class="col-md-12">
                        <div class="scroll-x">
                            <table class="table table-hover text-nowrap">
                                <thead>
                                <tr>
                                    <th>Date</th>
                                    <th>Status</th>
                                    <th>Start Time</th>
                                    <th>Status</th>
                                    <th>End Time</th>
                                    <th>Duration</th>
                                    <th>Remarks</th>
                                </tr>
                                </thead>
                                <tbody>
                                <?  $i=0; $total_dur=0; $status_array = array('0'=>'','1'=>'Start','2'=>'Pause','3'=>'Resume','4'=>'Terminate','5'=>'Completed');
                                foreach($work_updates as $work_update){ $i++; $dur=""; $wtype = $work_update['type'];
                                    $dur = (strtotime($work_update['etime'])-strtotime($work_update['stime']))/60;  $dur = round($dur);
                                    $total_dur += $dur;
                                ?>
                                    <tr>
                                        <td align="center"><?=dateFormat($work_update['udate']);?></td>
                                        <td align="center"><?=$status_array[$work_update['sstatus']];?></td>
                                        <td align="center"><?=date('h:i A',strtotime($work_update['stime']));?></td>
                                        <td align="center"><?=$status_array[$work_update['estatus']];?></td>
                                        <td align="center"><? if($work_update['estatus']!='0'){ echo date('h:i A',strtotime($work_update['etime'])); } ?></td>
                                        <td align="center"><?=$dur;?></td>
                                        <td align="center"><?=$work_update['remarks'];?></td>
                                    </tr>
                                <? } ?>
                                </tbody>
                                <tfoot>
                                    <td colspan="5" align="center"><b>Total</b></td>
                                    <td align="center"><b><?=$total_dur;?></b></td>
                                    <td></td>
                                </tfoot>
                            </table>
                        </div>
                    </div>
                </div>
                <? if($wtype==1 && $work_det['category']!='0' && ($work_det['wstatus']=='2' || $work_det['wstatus']=='3')){ 
                    
                    $avg = ($work_det['wtaken']-$work_det['nattend'])/($work_det['wcount']-$work_det['nattend']); $avg = round($avg,2); ?>
                    <div class="row">
                        <div class="col-sm-6">
                            <div class="row">
                                <label class="col-sm-4 col-form-label">Call/Mail Count</label>
                                <label class="col-sm-1 col-form-label">:</label>
                                <div class="col-sm-6 col-form-label"><?=$work_det['wcount']; ?></div>
                                <label class="col-sm-1 col-form-label"></label>
                            </div>
                            <div class="row">
                                <label class="col-sm-4 col-form-label">Attended</label>
                                <label class="col-sm-1 col-form-label">:</label>
                                <div class="col-sm-6 col-form-label"><?=($work_det['wcount']-$work_det['nattend']);?></div>
                                <label class="col-sm-1 col-form-label"></label>
                            </div>
                        </div>
                        <div class="col-sm-6">
                            <div class="row">
                                <label class="col-sm-4 col-form-label">Not Attended</label>
                                <label class="col-sm-1 col-form-label">:</label>
                                <div class="col-sm-6 col-form-label"><?=$work_det['nattend'];?></div>
                                <label class="col-sm-1 col-form-label"></label>
                            </div>
                            <div class="row">
                                <label class="col-sm-4 col-form-label">Avg. Time</label>
                                <label class="col-sm-1 col-form-label">:</label>
                                <div class="col-sm-6 col-form-label"><?=$avg;?> Min</div>
                                <label class="col-sm-1 col-form-label"></label>
                            </div>
                        </div>
                    </div>
                <? } ?>
            <? } ?>
        <? } ?>
    </div>    
</div>
<div class="card card-outline card-warning">
    <div class="card-header">
        <h3 class="card-title">Work Followup</h3>
    </div>
	<div class="card-body">
	    <? if(!empty($work_followups)){ ?>
            <div class="row">
                <div class="col-md-12">
                    <div class="scroll-x">
                        <table class="table table-hover text-nowrap">
                            <thead>
                            <tr>
                                <th>Date</th>
                                <th>Contacted Person</th>
                                <th>Contact No</th>
                                <th>Remarks</th>
                                <th>Attachment</th>
                                <th>Audio</th>
                            </tr>
                            </thead>
                            <tbody>
                            <?  foreach($work_followups as $work_followup){ ?>
                                <tr>
                                    <td><?=dateFormat($work_followup['pdate']);?></td>
                                    <td><?=$work_followup['person'];?></td>
                                    <td><?=$work_followup['contact_no'];?></td>
                                    <td><?=$work_followup['remarks'];?></td>
                                    <td><? if($work_followup['attachment']!=''){ ?><a href="<?=base_url().'assets/files/work/followup_attachment/'.$work_followup['attachment'];?>" target="blank_">View</a><? } ?></td>
                                    <td><? if($work_followup['audio']!=''){ ?><a href="<?=base_url().'assets/files/work/followup_audio/'.$work_followup['audio'];?>" target="blank_">View</a><? } ?></td>
                                </tr>
                            <? } ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        <? } ?>
    </div>    
</div>