<script src="https://ajax.googleapis.com/ajax/libs/jquery/1.6.1/jquery.min.js"></script>
<script>
    $( document ).ready(function() {
        $('.chkmain').click(function() {
			if (this.checked){
				$( ".chksub").prop('checked', true);
			}else{
				$( ".chksub").prop('checked', false);
			}
			get_total();
		});
		
		$(".chksub").on('click',function(a){
            get_total();
        });
        
        $(".det").on('keyup',function(a){
            get_total();
        });
    });
    
    function get_total()
    {
        $("#total-time").html('');
        $("#total-amount").html();
        var total_time=0; total_amount=0;
        $(".chksub").each(function() {
            
            if($(this).is(':checked')){
                
                var wid = $(this).val();
                var time = parseFloat($("#wtime"+wid).val());
                var amount = parseFloat($("#wamount"+wid).val());
                    
                if(isNaN(time)){ time=0; }
                if(isNaN(amount)){ amount=0; }
                    
                total_time += time;
                total_amount += amount;
            }
        });
            
        total_amount = total_amount.toFixed(2);
        $("#total-time").html(total_time);
        $("#total-amount").html(total_amount);
    }
</script>
<div class="card card-primary card-outline">
	<form action="<?=base_url('work_estimate/add');?>" method="post">
        <div class="card-body">
            <div class="row">
                <div class="col-md-4">
                    <div class="form-group">
                        <label class="required">Date</label>
                        <input type="text" class="form-control" name="edate" value="<?=$edate;?>" <?=$disabled;?>>
                    </div>
                </div>
                <div class="col-md-8">
                    <label class="required">Client</label>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <?=form_dropdown("client_id",$clients,set_value('client_id',$client_id),"class='form-control select2bs4' required $disabled");?>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <?=form_submit(array('name'=>'btn_get','class'=>'btn btn-primary','value'=>'Get Details'));?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>
<? if(!empty($work_array)){ ?>
    <div class="card card-primary card-outline">
    	<form action="<?=base_url('work_estimate/add');?>" method="post">
    	    <input type="hidden" name="e_date" value="<?=$edate;?>">
    	    <input type="hidden" name="client" value="<?=$client_id;?>">
            <div class="card-body">
                <div class="row">
                    <div class="col-sm-6">
                        <div class="form-group row">
                            <label class="col-sm-4 text-right">Client :</label>
                            <div class="col-sm-8"><?=$this->client->get_name($client_id);?></div>
                        </div>
                    </div>
                    <div class="col-sm-6">
                        <div class="form-group row">
                            <label class="col-sm-4 text-right">Date :</label>
                            <div class="col-sm-8"><?=dateFormat($edate);?></div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <div class="scroll">
                            <table class="table table-bordered">
                                <thead>
                                <tr>
                                    <th>#</th>
                                    <td align="center"><div class="icheck-primary d-inline"><input type="checkbox" id="checkall" class="chkmain"><label for="checkall"></label></div></td>
                                    <th>Date</th>
                                    <th>Description</th>
                                    <th>Time</th>
                                    <th>Amount</th>
                                </tr>
                                </thead>
                                <tbody>
                                    <? $i=0; foreach($work_array as $work){ ?>
                                        <tr>
                                            <td><?=++$i;?></td> 
                                            <td align="center"><div class="icheck-primary d-inline"><input type="checkbox" id="checksub<?=$work['id'];?>" class="chksub" name="posted[]" value="<?=$work['id'];?>"><label for="checksub<?=$work['id'];?>"></label></div></td>
                                            <td><?=dateFormat($work['cdate']);?></td>
                                            <td><?=$work['description'];?></td>
                                            <td><input type="text" class="form-control text-center det" id="wtime<?=$work['id'];?>" name="wtime<?=$work['id'];?>" value="<?=$work['wtime'];?>"></td>
                                            <td><input type="text" class="form-control text-right det" id="wamount<?=$work['id'];?>" name="wamount<?=$work['id'];?>"></td>
                                        </tr>
                                    <? } ?>
                                </tbody>
                                <tfoot>
                                <tr>
                                    <th colspan="4">Grand Total</th>
                                    <th class="text-center"><span id="total-time">0</span></th>
                                    <th class="text-right"><span id="total-amount">0</span></th>
                                </tr>
                                </tfoot>
                            </table>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <div class="form-group">
                            <?=form_submit(array('name'=>'btn_save','class'=>'btn btn-primary float-right','value'=>'Generate'));?>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
<? } ?>