<div class="card card-default">
	<form action="<?=base_url('work_estimate/report');?>" method="post">
        <div class="card-body">
            <div class="row">
              	<div class="col-md-4">
                    <div class="form-group">
                        <label>Client</label>
                        <?=form_dropdown("client_id",$clients,set_value('client_id',$client_id),"class='form-control select2bs4'");?>
                    </div>
                </div>
                <div class="col-md-2">
                    <div class="form-group">
                        <label>From Date</label>
                        <input type="date" class="form-control" name="fdate" id="fdate" value="<?=$fdate;?>">
                    </div>
                </div>
                <div class="col-md-2">
                    <div class="form-group">
                        <label>To Date</label>
                        <input type="date" class="form-control" name="tdate" id="tdate" value="<?=$tdate;?>">
                    </div>
                </div>
                <div class="col-md-4">
                    <label>Status</label>
                    <div class="row">
                        <div class="col-md-9">
                            <div class="form-group">
                                <select class="form-control" name="estatus" id="estatus">
                                    <option value="all">Select</option>
                                    <option value="0">Pending</option>
                                    <option value="1">Invoice</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <?=form_submit(array('name'=>'btn_get','class'=>'btn btn-primary','id'=>'btn-filter','value'=>'Go'));?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>
<? if(!empty($estimates)){ ?>
    <div class="card card-default">
        <div class="card-body">
            <div class="row">
                <div class="col-12">
                    <div class="scroll-x">
                        <table id="table" class="table table-bordered">
                            <thead>
                            <tr>
                                <th>#</th>
                                <th>Date</th>
                                <th>Client</th>
                                <th>Amount</th>
                                <th>Status</th>
                                <th>Actions</th>
                            </tr>
                            </thead>
                            <tbody>
                                <? $i=0; foreach($estimates as $estimate){ 
                                    $eclass=""; $estatus="";
                                    if($estimate['estatus']=='0'){ $eclass="badge-info"; $estatus="Pending"; }
                                    else if($estimate['estatus']=='1'){ $eclass="badge-success"; $estatus="Invoice"; } 
                                    $amount = $this->work->get_estimate_amount($estimate['id']); ?>
                                    <tr>
                                        <td align="center"><?=++$i;?></td>
                                        <td align="center"><?=dateFormat($estimate['edate']);?></td>
                                        <td><?=$this->client->get_name($estimate['client_id']);?></td>
                                        <td align="right"><?=numberFormat($amount);?></td>
                                        <td align="center"><span class="badge <?=$eclass;?>"><?=$estatus;?></span></td>
                                        <td align="center">
                                            <? if($estimate['estatus']=='0'){ ?>
                                                <a href="<?=base_url();?>work_estimate/invoice/<?=$estimate['id'];?>"><i class="fas fa-file-invoice text-lg text-success" title="Generate Invoice"></i></a>&nbsp;&nbsp;&nbsp;
                                            <? } ?>
                                            <a href="<?=base_url();?>work_estimate/estimate_pdf/<?=$estimate['id'];?>" target="blank_"><i class="fas fa-file-pdf text-lg text-danger" title="Work Estimate PDF"></i></a>&nbsp;&nbsp;&nbsp;
                                            <a href="<?=base_url();?>work_estimate/view/<?=$estimate['id'];?>" target="blank_"><i class="fas fa-search-plus text-lg text-primary" title="View Estimate"></i></a>&nbsp;&nbsp;&nbsp;
                                            <a href="<?=base_url();?>work_estimate/delete/<?=$estimate['id'];?>" onClick="return confirm(\'Are you sure you want to delete ?\');"><i class="fas fa-times text-lg text-danger" title="Delete"></i></a>
                                        </td>
                                    </tr>
                                <? } ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
<? } ?>